﻿using AZVIC.Ei8htPOS.BAL;
using AZVIC.Ei8htPOS.Entities;
using AZVIC.Ei8htPOS.Utilities;
using System;
using System.Collections.Generic;
using System.Linq;
using System.Web;
using System.Web.UI;
using System.Web.UI.WebControls;

namespace AZVIC.Ei8htPOS.WebUI.Admin.Masters.Color
{
    public partial class EditColor : System.Web.UI.Page
    {
        private ProductColor myColor;

        protected void Page_Load(object sender, EventArgs e)
        {
            WebSession.RedirectToAdminDashBoard(false);

            if (!IsPostBack)
            {
                if (Request.QueryString["UniqueID"] != null)
                {
                    hdProductColorID.Value = Request.QueryString["UniqueID"].ToString();
                    ShowProductColor();
                }
            }
        }

        private void ShowProductColor()
        {
            myColor = ProductColorBL.GetItem(Guid.Parse(hdProductColorID.Value.Trim()), string.Empty);
            if (myColor != null)
            {
                hdProductColorID.Value = myColor.UniqueID.ToString();
                txtColorName.Text = myColor.ColorName;
                txtSequenceNo.Text = myColor.SequenceNo.ToString();
                chkIsActive.Checked = myColor.IsActive;
            }
        }

        protected void btnSave_Click(object sender, EventArgs e)
        {
            if (ValidatePageValue())
            {
                myColor = new ProductColor();
                if (hdProductColorID.Value.Trim().Length == 0)
                    myColor.Mode = GlobalConfigurations.Mode.Insert;
                else
                {
                    myColor.Mode = GlobalConfigurations.Mode.Update;
                    myColor.UniqueID = Guid.Parse(hdProductColorID.Value.Trim());
                }

                myColor.ColorName = txtColorName.Text.Trim();
                myColor.SequenceNo = int.Parse(txtSequenceNo.Text.Trim());
                myColor.IsActive = chkIsActive.Checked;
                myColor.UserAccountID = (WebSession.CurrentAdminUser != null ? WebSession.CurrentAdminUser.UniqueID : Guid.Empty);

                if (ProductColorBL.Save(myColor))
                {
                    WebUtilities.OpenNewAddEditDialog(this, "Success", "Product Color details has been saved successfully.<br>Do you want to add another Product Color?", this.ResolveClientUrl("~/Admin/Masters/Color/Colors.aspx"));
                }
            }
        }

        protected void btnCancel_Click(object sender, EventArgs e)
        {
            Response.Redirect("~/Admin/Masters/Color/Colors.aspx", false);
        }

        private bool ValidatePageValue()
        {
            if (!ValidationUtility.ValidateString(txtColorName.Text.Trim()))
            {
                ScriptManager.RegisterStartupScript(this, GetType(), "Verde", "validationMsgBottom('#" + txtColorName.ClientID + "', 'Please enter Product Color Name.'); ", true);
                return false;
            }

            if (!ValidationUtility.ValidateInt(txtSequenceNo.Text.Trim()))
            {
                ScriptManager.RegisterStartupScript(this, GetType(), "Verde", "validationMsgBottom('#" + txtSequenceNo.ClientID + "', 'Please enter valid Display Order.'); ", true);
                return false;
            }

            return true;
        }
    }
}